/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.config.Reg;
import com.izforge.izpack.api.config.Registry;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.ValueImpl;
import com.izforge.izpack.util.OsVersion;
import java.io.Serializable;
import java.util.Set;

public class RegistryValue
extends ValueImpl
implements Serializable {
    private static final long serialVersionUID = 97879516787269847L;
    public String root;
    public String key;
    public String value;
    private String resolvedValue;

    public RegistryValue(String root, String key, String value) {
        this.root = root;
        this.key = key;
        this.value = value;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void validate() throws Exception {
        if (this.root == null && this.key == null || this.root != null && this.root.length() <= 0 && this.key != null && this.key.length() <= 0) {
            throw new Exception("No or empty registry key path");
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        if (this.root != null) {
            str.append("root: ").append(this.root).append(", ");
        }
        if (this.key != null) {
            str.append("key: ").append(this.key).append(", ");
        }
        if (this.value != null) {
            str.append("value: ").append(this.value).append(", ");
        }
        if (this.resolvedValue != null) {
            str.append("resolved: ").append(this.resolvedValue);
        }
        return str.toString();
    }

    @Override
    public String resolve() throws Exception {
        if (!OsVersion.IS_WINDOWS) {
            throw new Exception("Registry access allowed only on Windows OS");
        }
        Reg reg = null;
        Registry.Key regkey = null;
        if (this.root != null) {
            reg = new Reg(this.root);
        }
        if (this.key != null) {
            if (reg == null) {
                reg = new Reg(this.key);
            }
            regkey = reg.get(this.key);
        }
        if (regkey != null) {
            this.resolvedValue = (String)regkey.get(this.value);
            return this.resolvedValue;
        }
        return null;
    }

    @Override
    public String resolve(VariableSubstitutor ... substitutors) throws Exception {
        if (!OsVersion.IS_WINDOWS) {
            throw new Exception("Registry access allowed only on Windows OS");
        }
        Reg reg = null;
        Registry.Key regkey = null;
        if (this.root != null) {
            String _root_ = this.root;
            for (VariableSubstitutor substitutor : substitutors) {
                _root_ = substitutor.substitute(_root_);
            }
            reg = new Reg(_root_);
        }
        if (this.key != null) {
            String _key_ = this.key;
            for (VariableSubstitutor substitutor : substitutors) {
                _key_ = substitutor.substitute(_key_);
            }
            if (reg == null) {
                reg = new Reg(_key_);
            }
            regkey = reg.get(_key_);
        }
        if (regkey != null) {
            String _value_ = this.value;
            for (VariableSubstitutor substitutor : substitutors) {
                _value_ = substitutor.substitute(_value_);
            }
            this.resolvedValue = (String)regkey.get(_value_);
            return this.resolvedValue;
        }
        return null;
    }

    @Override
    public Set<String> getVarRefs() {
        return RegistryValue.parseUnresolvedVariableNames(this.root, this.key, this.value);
    }
}

