/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.installer.automation.AutomatedInstaller;
import com.izforge.izpack.installer.bootstrap.InstallerConsole;
import com.izforge.izpack.installer.bootstrap.InstallerGui;
import com.izforge.izpack.installer.console.ConsoleInstallerAction;
import com.izforge.izpack.installer.container.impl.AutomatedInstallerContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.StringTool;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;

public class Installer {
    private static int installerMode = 0;
    private static Logger logger;
    public static final int INSTALLER_GUI = 0;
    public static final int INSTALLER_AUTO = 1;
    public static final int INSTALLER_CONSOLE = 2;
    public static final String LOGGING_CONFIGURATION = "/com/izforge/izpack/installer/logging/logging.properties";

    public static void main(String[] args) {
        try {
            Installer.initializeLogging();
            Installer installer = new Installer();
            installer.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initializeLogging() {
        LogManager manager = LogManager.getLogManager();
        try {
            InputStream stream = Installer.class.getResourceAsStream(LOGGING_CONFIGURATION);
            if (stream != null) {
                manager.readConfiguration(stream);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Logger rootLogger = Logger.getLogger("com.izforge.izpack");
        rootLogger.setUseParentHandlers(false);
        if (Debug.isDEBUG()) {
            rootLogger.setLevel(Level.FINE);
        } else {
            rootLogger.setLevel(Level.INFO);
        }
        logger = Logger.getLogger(Installer.class.getName());
        logger.info("Logging initialized at level '" + rootLogger.getLevel() + "'");
    }

    private void start(String[] args) {
        logger.info("Commandline arguments: " + StringTool.stringArrayToSpaceSeparatedString(args));
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IzPack");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            Iterator<String> args_it = Arrays.asList(args).iterator();
            int type = 0;
            ConsoleInstallerAction consoleAction = ConsoleInstallerAction.CONSOLE_INSTALL;
            String path = null;
            String langcode = null;
            String media = null;
            String defaultsFile = null;
            while (args_it.hasNext()) {
                String arg = args_it.next().trim();
                try {
                    if ("-console".equalsIgnoreCase(arg)) {
                        type = 2;
                        continue;
                    }
                    if ("-auto".equalsIgnoreCase(arg)) {
                        type = 1;
                        continue;
                    }
                    if ("-defaults-file".equalsIgnoreCase(arg)) {
                        defaultsFile = args_it.next().trim();
                        continue;
                    }
                    if ("-options-template".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_GEN_TEMPLATE;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_FROM_TEMPLATE;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options-system".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_FROM_SYSTEMPROPERTIES;
                        continue;
                    }
                    if ("-options-auto".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = ConsoleInstallerAction.CONSOLE_FROM_SYSTEMPROPERTIESMERGE;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-language".equalsIgnoreCase(arg)) {
                        langcode = args_it.next().trim();
                        continue;
                    }
                    if ("-media".equalsIgnoreCase(arg)) {
                        media = args_it.next().trim();
                        continue;
                    }
                    type = 1;
                    path = arg;
                }
                catch (NoSuchElementException e) {
                    logger.log(Level.SEVERE, "Option \"" + arg + "\" requires an argument", e);
                    System.exit(1);
                }
            }
            Options defaults = this.getDefaults(defaultsFile);
            if (type == 1 && path == null && defaults == null) {
                logger.log(Level.SEVERE, "Unattended installation mode needs either a defaults file specified by '-defaults-file' or an installation record XML file as argument");
                System.exit(1);
            }
            this.launchInstall(type, consoleAction, path, langcode, media, defaults, args);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(1);
        }
    }

    public Options getDefaults(String path) {
        File overridePropFile = null;
        if (path != null) {
            overridePropFile = new File(path);
        } else {
            try {
                File jarFile = new File(DefaultVariables.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                String jarDir = jarFile.getParentFile().getPath();
                overridePropFile = new File(jarDir, FilenameUtils.getBaseName(jarFile.getPath()) + ".defaults");
                if (!overridePropFile.exists()) {
                    overridePropFile = null;
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (overridePropFile != null) {
            Config config = Config.getGlobal().clone();
            config.setFileEncoding(Charset.forName("UTF-8"));
            config.setInclude(true);
            Options opts = new Options(config);
            opts.setFile(overridePropFile);
            return opts;
        }
        return null;
    }

    private void launchInstall(int type, ConsoleInstallerAction consoleAction, String path, String langCode, String mediaDir, Options defaults, String[] args) throws Exception {
        if (type == 0 && GraphicsEnvironment.isHeadless()) {
            type = 2;
        }
        installerMode = type;
        switch (type) {
            case 0: {
                InstallerGui.run(langCode, mediaDir, defaults);
                break;
            }
            case 1: {
                this.launchAutomatedInstaller(path, mediaDir, defaults, args);
                break;
            }
            case 2: {
                InstallerConsole.run(consoleAction, path, langCode, mediaDir, defaults, args);
            }
        }
    }

    private void launchAutomatedInstaller(String path, String mediaDir, Options defaults, String[] args) throws Exception {
        AutomatedInstallerContainer container = new AutomatedInstallerContainer();
        if (defaults != null) {
            Config config = defaults.getConfig();
            config.setInstallData(container.getComponent(AutomatedInstallData.class));
            defaults.load();
            logger.info("Loaded " + defaults.size() + " override(s) from " + defaults.getFile());
            DefaultVariables variables = container.getComponent(DefaultVariables.class);
            variables.setOverrides(defaults);
        }
        AutomatedInstaller automatedInstaller = container.getComponent(AutomatedInstaller.class);
        automatedInstaller.init(path, mediaDir, args);
        automatedInstaller.doInstall();
    }

    public static int getInstallerMode() {
        return installerMode;
    }
}

