/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.panels.target.TargetPanelHelper;

public class TargetPanelAutomation
implements PanelAutomation {
    @Override
    public void createInstallationRecord(InstallData installData, IXMLElement panelRoot) {
        XMLElementImpl ipath = new XMLElementImpl("installpath", panelRoot);
        ipath.setContent(installData.getInstallPath());
        IXMLElement prev = panelRoot.getFirstChildNamed("installpath");
        if (prev != null) {
            panelRoot.removeChild(prev);
        }
        panelRoot.addChild(ipath);
    }

    @Override
    public void runAutomated(InstallData installData, IXMLElement panelRoot) {
        IXMLElement ipath = panelRoot.getFirstChildNamed("installpath");
        String path = ipath.getContent();
        this.handleInstallPath(installData, path);
    }

    @Override
    public void processOptions(InstallData installData, Options options) {
        String path = (String)options.get("INSTALL_PATH");
        if (path != null) {
            this.handleInstallPath(installData, path);
        }
    }

    private void handleInstallPath(InstallData installData, String path) {
        path = installData.getVariables().replace(path);
        if (TargetPanelHelper.isIncompatibleInstallation(path, installData.getInfo().isReadInstallationInformation())) {
            throw new InstallerException(installData.getMessages().get("TargetPanel.incompatibleInstallation", new Object[0]));
        }
        installData.setInstallPath(path);
    }
}

